/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import tv.mapper.roadstuff.world.item.BrushItem;

public class BrushPacket {
    private int pattern;
    private float scroll;
    private int[] favs;

    public BrushPacket(int pattern, float scroll, int[] favs) {
        this.pattern = pattern;
        this.scroll = scroll;
        this.favs = favs;
    }

    public static void encode(BrushPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.pattern);
        buffer.writeFloat(packet.scroll);
        buffer.m_130089_(packet.favs);
    }

    public static BrushPacket decode(FriendlyByteBuf buffer) {
        int pattern = buffer.readInt();
        float scroll = buffer.readFloat();
        int[] favs = buffer.m_130100_();
        BrushPacket instance = new BrushPacket(pattern, scroll, favs);
        return instance;
    }

    public static void handle(BrushPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender.m_21205_().m_41720_() instanceof BrushItem) {
                CompoundTag nbt = sender.m_21205_().m_41783_();
                nbt.m_128405_("pattern", packet.pattern);
                nbt.m_128350_("scroll", packet.scroll);
                nbt.m_128385_("favs", packet.favs);
            } else if (sender.m_21206_().m_41720_() instanceof BrushItem) {
                CompoundTag nbt = sender.m_21206_().m_41783_();
                nbt.m_128405_("pattern", packet.pattern);
                nbt.m_128350_("scroll", packet.scroll);
                nbt.m_128385_("favs", packet.favs);
            }
        });
        context.get().setPacketHandled(true);
    }
}

